<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/*
 * Created on 05. Jan. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 */

/**
 * FontFaceDeclFragment class file.  
 *   
 * PHP versions 5
 *   
 * LICENSE:
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: FontFaceDeclFragment.php 253 2007-08-01 14:14:10Z nmarkgraf $
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  global
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     SVN: $Id: FontFaceDeclFragment.php 253 2007-08-01 14:14:10Z nmarkgraf $
 * @link        http://opendocumentphp.org
 * @since       0.5.0 - 08. Feb. 2007
 */

/**
 * 
 */
require_once 'OpenDocumentPHP/global/FontFace.php';
require_once 'OpenDocumentPHP/util/Fragment.php';

/**
 * FontFaceDeclFragment class.  
 *   
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  global
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     Release: @package_version@
 * @link        http://opendocumentphp.org
 * @since       0.5.0 - 08. Feb. 2007
 */
class FontFaceDeclFragment extends ODPElement {

	/**
	 * Constructor method.
	 * 
	 * @param      DOMElement|null If a DOMElement is given, this is will be the node, else a new node is created.
	 * @since 	   0.5.0 - 08. Feb. 2007
	 */
	function __construct($elem = null) 
	{
	   if (is_null($elem)) {
	       parent::__construct('office:font-face-decls', '', self::OFFICE);
	   } else {
	       parent::__construct($elem);	       
	   }
	   /*
		parent :: __construct($domFragment, $root);
		if (isset($root) && $root != null) {
		} else {
			$this->root = $this->domFragment->createElementNS(self :: OFFICE, 'office:font-face-decls');
		}
       */ 
	}
	
	/**
	 * Create a new/next FontFace class.
	 * 
	 * @access		public
	 * @return      FontFace A new FontFace class.
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	function nextFontFace() 
	{
	   /*
	    * Create a new font face class,
	    */   
		$fontface = new FontFace();
		/*
		 * add it to the current document,
		 */
		$this->appendChild($fontface->getElement());
		/*
		 * and return the class to the caller.
		 */
		return $fontface;
	}

	/**
	 * Import newnode tree as new FontFaceDecl.
	 *  
	 * @access		public
	 * @since 		0.5.0 - 08. Feb. 2007	 
	 */
	function importNode($newnode, $cleanFirst=true) 
	{
        /*
         * Check if we want to remove all our own children first?
         */	    
        if ($cleanfirst) {
            /*
             * So we remove every child of the current list.
             */
            foreach($this->childNodes as $child) {
                $this->removeChild($child);
            }
        }
        
        /*
         * Now add every child of $tmp to our document.
         * $tmp should cover the <office:font-face-decl> tag of newnode, so its 
         * children are exactly what we want to add to our own <office:font-face-decl> 
         * tag.
         */
        /*
         * We need the real DOMElement, so we _MUST_ use the getElement() method on
         * ODPElement classes to get the DOMNodeList in childNodes attribute. 
         */
        if ($newnode instanceof ODPElement) {
            $newChildren = $newnode->getElement()->childNodes;
        } else {
            $newChildren = $newnode->childNodes;
        }
        for($i=0, $l=$newChildren->length; $i < $l; $i++) {
            /*
             * Get next child
             */
            $child = $newChildren->item($i);
            /*
             * Import (deep) the nodes temporary to our document. Again we need the real
             * Element, so we _MUST_ use the getElement() method to get the ownerDocument
             * attribute.
             */            
            $newChild = $this->getElement()->ownerDocument->importNode($child, true);
            /*
             * Append to this node
             */            
            $this->appendChild($newChild);
            /*
             * Remove $newChild and mark it for GC
             */
        }
        
	}
}
?>